/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.udp;

import com.ibm.hwmca.fw.fcs.FcsException;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.impl.udp.DatagramSocketListener;
import com.ibm.hwmca.fw.fcs.impl.udp.FcsDatagram;
import com.ibm.hwmca.fw.fcs.impl.udp.NotificationQueue;
import com.ibm.hwmca.fw.fcs.impl.udp.OutgoingDatagramPortOwner;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class IncomingDatagramPortOwner {
    private static final String TRACE_MASKD = "XFCSIDPD";
    private static final String TRACE_MASKF = "XFCSIDPF";
    private static final String TRACE_MASKT = "XFCSIDPT";
    private static IncomingDatagramPortOwner _singleton;
    private static boolean useMulticast;
    private static DatagramSocket inSocket;
    private static DatagramSocketListener[] socketListeners;
    private static NotificationQueue datagramQueue;
    private boolean useTestCode = false;
    private static MachineId machineId;

    private IncomingDatagramPortOwner() {
        datagramQueue = new NotificationQueue();
        this.buildSocket();
    }

    private synchronized void buildSocket() {
        block17: {
            boolean deprecated = true;
            if (deprecated) {
                return;
            }
            if (this.useTestCode) {
                try {
                    int i;
                    if (socketListeners != null) {
                        i = 0;
                        while (i < socketListeners.length) {
                            socketListeners[i].closeSocket();
                            ++i;
                        }
                    }
                    if (machineId == null) break block17;
                    socketListeners = new DatagramSocketListener[machineId.getNicAddresses().length];
                    i = 0;
                    while (i < socketListeners.length) {
                        if (useMulticast) {
                            MulticastSocket tmpSocket = new MulticastSocket(9900);
                            tmpSocket.joinGroup(InetAddress.getByName("225.4.5.6"));
                            tmpSocket.setInterface(machineId.getNicAddresses()[i]);
                            IncomingDatagramPortOwner.socketListeners[i] = new DatagramSocketListener(tmpSocket, datagramQueue);
                        } else {
                            IncomingDatagramPortOwner.socketListeners[i] = new DatagramSocketListener(new DatagramSocket(9900, machineId.getNicAddresses()[i]), datagramQueue);
                        }
                        socketListeners[i].start();
                        ++i;
                    }
                }
                catch (SocketException se) {
                    Trace.trace(TRACE_MASKF, se);
                    socketListeners = null;
                }
                catch (IOException ioe) {
                    Trace.trace(TRACE_MASKF, ioe);
                    socketListeners = null;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, e);
                    socketListeners = null;
                }
            } else {
                try {
                    if (inSocket != null) {
                        inSocket.close();
                    }
                    if (useMulticast) {
                        inSocket = new MulticastSocket(9900);
                        ((MulticastSocket)inSocket).joinGroup(InetAddress.getByName("225.4.5.6"));
                        ((MulticastSocket)inSocket).setInterface(InetAddress.getLocalHost());
                        break block17;
                    }
                    inSocket = new DatagramSocket(9900);
                }
                catch (SocketException se) {
                    inSocket = null;
                }
                catch (IOException ioe) {
                    inSocket = null;
                }
            }
        }
    }

    public void closeSocket() {
        block7: {
            block6: {
                if (!this.useTestCode) break block6;
                if (socketListeners == null) break block7;
                int i = 0;
                while (i < socketListeners.length) {
                    if (socketListeners[i] != null) {
                        try {
                            socketListeners[i].closeSocket();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                socketListeners = null;
                break block7;
            }
            if (inSocket == null) break block7;
            try {
                inSocket.close();
                inSocket = null;
            }
            catch (Exception e) {}
        }
    }

    public static synchronized IncomingDatagramPortOwner getIncomingDatagramPortOwner() {
        if (_singleton == null) {
            _singleton = new IncomingDatagramPortOwner();
        }
        return _singleton;
    }

    public static void setUseMulticast(boolean value) {
        if (useMulticast != value) {
            useMulticast = value;
            IncomingDatagramPortOwner.getIncomingDatagramPortOwner().buildSocket();
            OutgoingDatagramPortOwner.getOutgoingDatagramPortOwner().closeSocket();
            OutgoingDatagramPortOwner.getOutgoingDatagramPortOwner();
        }
    }

    public static boolean isUseMulticast() {
        return useMulticast;
    }

    public DatagramPacket receive() {
        DatagramPacket inPacket;
        block8: {
            if (this.useTestCode) {
                Object inPacket2 = null;
                if (socketListeners == null) {
                    this.buildSocket();
                }
                if (socketListeners != null) {
                    DatagramPacket fcsDatagram = (DatagramPacket)datagramQueue.readItem();
                    return fcsDatagram;
                }
                return null;
            }
            inPacket = null;
            if (inSocket == null) {
                this.buildSocket();
            }
            if (inSocket == null) break block8;
            byte[] buffer = new byte[504];
            inPacket = new DatagramPacket(buffer, buffer.length);
            try {
                inSocket.receive(inPacket);
                FcsDatagram datagram = new FcsDatagram(inPacket);
            }
            catch (FcsException fcse) {
                inPacket = null;
            }
            catch (IOException ioe) {
                inPacket = null;
            }
            catch (Exception e) {
                inPacket = null;
            }
        }
        return inPacket;
    }

    public void networkSettingsChanged() {
        this.closeSocket();
        this.buildSocket();
        MachineId tmp = null;
        try {
            tmp = FcsServer.getFcsServer().getLocalMachineId();
            if (tmp != null) {
                machineId = tmp;
            }
        }
        catch (Exception e) {}
    }

    public void restart() {
        if (this.useTestCode) {
            if (socketListeners == null) {
                this.buildSocket();
            }
        } else if (inSocket == null) {
            this.buildSocket();
        }
    }

    public static void setMachineId(MachineId newMachineId) {
        machineId = newMachineId;
    }

    static {
        useMulticast = false;
    }
}

